/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_04;
import java.awt.*; import java.awt.event.*; import java.net.URLDecoder;
import javax.swing.*; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class AppletSwingEvent extends JAppletBase implements ActionListener {
	private JApplet applet; private JTextPane textPane = new JTextPane();
	private LayoutManager springLayout;
	private String text = ""; public Session session;
	private int startedCount = 0; private int stoppedCount = 0;
	private JButton showButton = new JButton();
	
	public void notesAppletStart () {
		startedCount++;
		final JPanel panel = new JPanel();
		panel.setLayout(springLayout);
		panel.setBackground(new Color (255,255,255));
		getContentPane().add(panel);
		textPane.setBounds(0, 50, 250, 100);
		panel.add(textPane);
		panel.add(showButton);
		try {
			if (isNotesLocal()) {
				session = this.getSession ();
			} else {
				session = this.getSession("", "");
			}
		} catch (NotesException e) {
			text = e.id + " " + e.text;
		} catch (Exception e) {
			e.printStackTrace();
		}
		setupGUI();
	}
	
	public void notesAppletStop() {
		/* Hinweis: In einigen AppletViewern wird das Applet beendet, wenn
		 * die session beendet wird. Fr diesen Fall muss die session
		 * im notesAppletInit geffnet und im notesAppletDestroy geschlossen werden.
		 */
		stoppedCount++;
		try {
			this.closeSession(session);
		} catch (NotesException e) {
			e.printStackTrace();
		}
	}
	
	private void setupGUI() {
		showButton.addActionListener(this);
		showButton.setBounds(0, 0, 200, 30);
		showButton.setText("Aktuellen Benutzer anzeigen.");
	}
	
	public void actionPerformed(ActionEvent e) {
		try {
			if (isNotesLocal()) {
				NotesThread.sinitThread();
			}
			NotesAppletContext nac=null;
			try {
				nac = getContext(session);
			} catch (NotesException ne) {
				//ignore - Diese Exception tritt nur auf, falls ber einen Applet Viewer gestartet.
				//der Applet Context kann nur ber Domino (Client oder Browser) 
				//bezogen werden.
			}
			text = ("Swing (Event) Example: " + (isNotesLocal() ? "Lokal" : "Remote"))
					+ (nac!=null?"\nServer: " + URLDecoder.decode(nac.getServer())
					+ "\nDatabase: " + nac.getDatabase().getFileName():"") 
					+ "\nBenutzer: " + session.getCommonUserName() 
					+ "\nStart/Stop: " + startedCount + "/" + stoppedCount;
		} catch (NotesException e1) {
			text = e1.id + " " + e1.text;
		} catch (Exception e2) {
			e2.printStackTrace();
		} finally {
			if (isNotesLocal()) {
				NotesThread.stermThread();
			}
		}
		textPane.setText(text);
	}
}
